<?php
/* =====================================================
   RAHFAV FOUNDATION – LANDING PAGE
   Trauma-Informed NGO Platform
   Framework-Compatible
===================================================== */

// 1. Timezone
date_default_timezone_set('Africa/Lagos');

// 2. Error Handling (Production Safe)
error_reporting(E_ERROR | E_WARNING | E_WARNING);
ini_set('display_errors', 0);

session_start();

include('db/db.php');
include "app/functions.php";

$curryr = date('Y');
$iname = "Rahfav Foundation";
?>

<!DOCTYPE html>
<html lang="en" class="js">
<head>
	<meta charset="utf-8">
	<meta name="author" content="Rahfav Foundation">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="description" content="Confidential trauma-informed rehabilitation and support for survivors of abuse.">
	<link rel="shortcut icon" href="images/favicon.png">
	<title><?php echo $iname ?> | Restoring Dignity. Renewing Hope. Rebuilding Lives.</title>

	<link rel="stylesheet" href="assets/css/vendor.bundle.css?ver=192">
	<link rel="stylesheet" href="assets/css/style-rahfav.css?ver=192" id="changeTheme">
	<link rel="stylesheet" href="assets/css/theme.css?ver=192">

	<style>
		/* --- SAFETY-FIRST HERO BANNER WITH ANIMATED BACKGROUND --- */
		#rahfav-banner-context {
			position: relative;
			overflow: hidden;
			background-color: #000;
			min-height: 65vh !important;
			height: 65vh !important;
		}

		.banner-bg-carousel {
			position: absolute;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			z-index: 1;
		}

		.banner-bg-carousel span {
			position: absolute;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			background-size: cover;
			background-position: center;
			background-repeat: no-repeat;
			opacity: 0;
			animation: rahfavFade 21s infinite;
		}

		.banner-bg-carousel span:nth-child(1) {
			background-image: url('https://images.unsplash.com/photo-1520975916090-3105956dac38?q=80&w=1920&auto=format&fit=crop');
			animation-delay: 0s;
		}

		.banner-bg-carousel span:nth-child(2) {
			background-image: url('https://images.unsplash.com/photo-1500648767791-00dcc994a43e?q=80&w=1920&auto=format&fit=crop');
			animation-delay: 7s;
		}

		.banner-bg-carousel span:nth-child(3) {
			background-image: url('https://images.unsplash.com/photo-1500530855697-b586d89ba3ee?q=80&w=1920&auto=format&fit=crop');
			animation-delay: 14s;
		}

		@keyframes rahfavFade {
			0% { opacity: 0; }
			10% { opacity: 0.22; }
			33% { opacity: 0.22; }
			43% { opacity: 0; }
			100% { opacity: 0; }
		}

		#rahfav-banner-context .banner-fs {
			min-height: 65vh !important;
			height: 65vh !important;
		}

		#rahfav-banner-context .nk-banner,
		#rahfav-banner-context .banner-wrap {
			position: relative;
			z-index: 5;
		}

		#rahfav-banner-context .banner-wrap {
			padding-top: 90px !important;
		}

		.safe-alert {
			background: #fff3f3;
			border-left: 6px solid #cc0000;
			padding: 18px;
			border-radius: 6px;
			color: #900;
			margin-bottom: 25px;
		}
	</style>
</head>

<body class="nk-body body-wider mode-onepage">

<div class="nk-wrap">

	<!-- ================= HEADER ================= -->
	<header class="nk-header page-header is-transparent is-sticky is-shrink" id="header">
		<div class="header-main">
			<div class="header-container header-container-s1">
				<div class="header-wrap">
					<div class="header-logo logo animated" data-animate="fadeInDown" data-delay=".65">
						<a href="./" class="logo-link">
							<img class="logo-dark" src="images/logo1.png" alt="Rahfav Foundation">
							<img class="logo-light" src="images/logo1-full-white.png" alt="Rahfav Foundation">
						</a>
					</div>

					<div class="header-nav-toggle">
						<a href="#" class="navbar-toggle" data-menu-toggle="header-menu">
							<div class="toggle-line"><span></span></div>
						</a>
					</div>

					<div class="header-navbar header-navbar-s1">
						<nav class="header-menu justify-content-between" id="header-menu">
							<ul class="menu animated remove-animation" data-animate="fadeInDown" data-delay=".75">
								<li class="menu-item"><a class="menu-link nav-link" href="#about">About Us</a></li>
								<li class="menu-item"><a class="menu-link nav-link" href="#services">Our Services</a></li>
								<li class="menu-item"><a class="menu-link nav-link" href="#help">Get Help</a></li>
								<li class="menu-item"><a class="menu-link nav-link" href="#donate">Donate</a></li>
								<li class="menu-item"><a class="menu-link nav-link" href="#contact">Contact</a></li>
							</ul>
							<ul class="menu-btns align-items-center animated remove-animation" data-animate="fadeInDown" data-delay=".85">
								<li>
									<a href="intake.php" class="btn btn-md btn-auto btn-outline btn-secondary no-change">
										<span>Get Help Now</span>
									</a>
								</li>
							</ul>
						</nav>
					</div>
				</div>
			</div>
		</div>

		<!-- ================= HERO ================= -->
		<div class="header-banner bg-theme-grad-alt" id="rahfav-banner-context">

			<!-- ✅ Animated Background Carousel -->
			<div class="banner-bg-carousel">
				<span></span>
				<span></span>
				<span></span>
			</div>

			<div class="nk-banner">
				<div class="banner banner-fs banner-single banner-with-token-box-s1">
					<div class="ui-shape ui-shape-header ui-shape-light"></div>
					<div class="banner-wrap">
						<div class="container">
							<div class="row align-items-center justify-content-center">
								<div class="col-sm-10 col-md-10 col-xl-9">
									<div class="banner-caption tc-light text-center">
										<div class="cpn-title animated" data-animate="fadeInUp" data-delay="1.1">
											<h1 class="title title-xl-s2 title-semibold">
												Restoring Dignity.<br>Renewing Hope.<br>Rebuilding Lives.
											</h1>
										</div>
										<div class="cpn-text animated" data-animate="fadeInUp" data-delay="1.25">
											<p class="lead">
												Confidential, trauma-informed rehabilitation and support for survivors of abuse.
											</p>
										</div>

										<div class="cpn-btns">
											<ul class="btn-grp justify-content-center animated" data-animate="fadeInUp" data-delay="1.45">
												<li>
													<a href="intake.php" class="btn btn-md btn-round btn-with-icon btn-light">
														<span>Get Help Now</span>
														<em class="icon fas fa-angle-double-right"></em>
													</a>
												</li>
												<li>
													<a href="emergency.php" class="btn btn-md btn-round btn-with-icon btn-outline btn-light">
														<span>Emergency Support</span>
														<em class="icon fas fa-angle-double-right"></em>
													</a>
												</li>
											</ul>
										</div>
									</div>
								</div>
							</div>
						</div>

						<div class="banner-social-wrap text-center animated" data-animate="fadeIn" data-delay="1.6">
							<ul class="banner-social banner-social-vertical">
								<li><a href="#"><em class="fab fa-facebook-f"></em></a></li>
								<li><a href="#"><em class="fab fa-twitter"></em></a></li>
								<li><a href="#"><em class="fab fa-instagram"></em></a></li>
								<li><a href="#"><em class="fab fa-youtube"></em></a></li>
							</ul>
						</div>

					</div>
				</div>
				<div class="nk-ovm mask-b mask-contain-bottom"></div>
			</div>
			<div id="particles-bg" class="particles-container particles-bg"></div>
		</div>
	</header>

	<!-- ================= MAIN CONTENT ================= -->
	<main class="nk-pages">

		<!-- ================= ABOUT ================= -->
		<section class="section bg-white ov-h" id="about">
			<div class="container">
				<div class="row justify-content-center text-center">
					<div class="col-lg-8">
						<div class="nk-block nk-block-text">
							<h2 class="title title-lg animated" data-animate="fadeInUp" data-delay=".1">
								Who We Are
							</h2>
							<p class="animated" data-animate="fadeInUp" data-delay=".2">
								Rahfav Foundation is a Nigeria-registered NGO dedicated to supporting survivors of
								physical, emotional, and sexual abuse. We provide safe spaces, professional counselling,
								advocacy, rehabilitation programmes, and reintegration support.
							</p>
							<p class="animated" data-animate="fadeInUp" data-delay=".3">
								Our work is rooted in dignity, confidentiality, compassion, and empowerment.
							</p>
						</div>
					</div>
				</div>
			</div>
		</section>

		<!-- ================= SERVICES ================= -->
		<section class="section bg-light ov-h" id="services">
			<div class="container">
				<div class="row justify-content-center text-center">
					<div class="col-lg-8">
						<div class="nk-block-text-head">
							<h2 class="title title-lg animated" data-animate="fadeInUp" data-delay=".1">
								What We Do
							</h2>
							<p class="animated" data-animate="fadeInUp" data-delay=".2">
								Holistic rehabilitation and survivor-centred care.
							</p>
						</div>
					</div>
				</div>

				<div class="row justify-content-center">
					<div class="col-md-4 animated" data-animate="fadeInUp" data-delay=".3">
						<div class="feature feature-s3 text-center">
							<div class="feature-icon">
								<em class="icon fas fa-heart"></em>
							</div>
							<h5 class="feature-title">Trauma-Informed Counselling</h5>
							<p>Confidential emotional support delivered by trained professionals.</p>
						</div>
					</div>

					<div class="col-md-4 animated" data-animate="fadeInUp" data-delay=".4">
						<div class="feature feature-s3 text-center">
							<div class="feature-icon">
								<em class="icon fas fa-hands-helping"></em>
							</div>
							<h5 class="feature-title">Rehabilitation Programmes</h5>
							<p>Life skills development, empowerment, and reintegration support.</p>
						</div>
					</div>

					<div class="col-md-4 animated" data-animate="fadeInUp" data-delay=".5">
						<div class="feature feature-s3 text-center">
							<div class="feature-icon">
								<em class="icon fas fa-balance-scale"></em>
							</div>
							<h5 class="feature-title">Advocacy & Legal Support</h5>
							<p>Guidance navigating rights, reporting, and protection systems.</p>
						</div>
					</div>

					<div class="col-md-4 animated" data-animate="fadeInUp" data-delay=".6">
						<div class="feature feature-s3 text-center">
							<div class="feature-icon">
								<em class="icon fas fa-home"></em>
							</div>
							<h5 class="feature-title">Safe Housing Referrals</h5>
							<p>Connections to emergency accommodation and protective services.</p>
						</div>
					</div>

					<div class="col-md-4 animated" data-animate="fadeInUp" data-delay=".7">
						<div class="feature feature-s3 text-center">
							<div class="feature-icon">
								<em class="icon fas fa-users"></em>
							</div>
							<h5 class="feature-title">Community Support Groups</h5>
							<p>Peer networks and healing spaces for shared recovery.</p>
						</div>
					</div>
				</div>
			</div>
		</section>

		<!-- ================= GET HELP ================= -->
		<section class="section bg-white ov-h" id="help">
			<div class="container">
				<div class="row justify-content-center text-center">
					<div class="col-lg-8">
						<div class="nk-block-text-head">
							<h2 class="title title-lg animated" data-animate="fadeInUp" data-delay=".1">
								Get Help
							</h2>
							<p class="animated" data-animate="fadeInUp" data-delay=".2">
								You are not alone. Support is available — safely, confidentially, and without judgement.
							</p>
						</div>

						<div class="safe-alert animated" data-animate="fadeInUp" data-delay=".3">
							If you are in immediate danger, please contact emergency services right now or use our emergency support form below.
						</div>

						<div class="btn-grp justify-content-center animated" data-animate="fadeInUp" data-delay=".4">
							<a href="intake.php" class="btn btn-md btn-round btn-primary">
								Start Confidential Intake
							</a>
							<a href="emergency.php" class="btn btn-md btn-round btn-outline btn-danger">
								Emergency Support
							</a>
						</div>

					</div>
				</div>
			</div>
		</section>

		<!-- ================= DONATE ================= -->
		<section class="section bg-light ov-h" id="donate">
			<div class="container">
				<div class="row justify-content-center text-center">
					<div class="col-lg-8">
						<div class="nk-block-text-head">
							<h2 class="title title-lg animated" data-animate="fadeInUp" data-delay=".1">
								Why Your Support Matters
							</h2>
							<p class="animated" data-animate="fadeInUp" data-delay=".2">
								Your generosity funds counselling sessions, shelter referrals, legal advocacy,
								and rehabilitation programmes that transform lives.
							</p>
						</div>

						<div class="btn-grp justify-content-center animated" data-animate="fadeInUp" data-delay=".3">
							<a href="donate.php" class="btn btn-md btn-round btn-primary">
								Donate Now
							</a>
							<a href="volunteer.php" class="btn btn-md btn-round btn-outline btn-secondary">
								Volunteer With Us
							</a>
						</div>

					</div>
				</div>
			</div>
		</section>

		<!-- ================= CONTACT ================= -->
		<section class="section bg-white ov-h" id="contact">
			<div class="container">
				<div class="row justify-content-center text-center">
					<div class="col-lg-8">
						<div class="nk-block-text-head">
							<h2 class="title title-lg animated" data-animate="fadeInUp" data-delay=".1">
								Contact & Support
							</h2>
							<p class="animated" data-animate="fadeInUp" data-delay=".2">
								Reach out safely — we’re here to listen.
							</p>
						</div>

						<div class="animated" data-animate="fadeInUp" data-delay=".3">
							<p><strong>24/7 Support Line:</strong> +234 (0) 9152 861106</p>
							<p><strong>Email:</strong> support@rahfavfoundation.org</p>
						</div>

						<div class="btn-grp justify-content-center animated" data-animate="fadeInUp" data-delay=".4">
							<a href="contact.php" class="btn btn-md btn-round btn-primary">
								Contact Us
							</a>
						</div>

					</div>
				</div>
			</div>
		</section>

	</main>

	<!-- ================= FOOTER ================= -->
	<footer class="nk-footer bg-theme-grad-alt">
		<section class="section section-l section-footer pb-0 tc-light tc-light-alt bg-transparent ov-h">
			<div class="ui-shape ui-shape-footer ui-shape-light"></div>
			<div class="container">
				<div class="nk-block block-footer">
					<div class="row my-md-0 mb-n4">

						<div class="col-lg-3 col-sm-4">
							<div class="wgs wgs-menu">
								<h6 class="wgs-title wgs-title-s2 text-white animated" data-animate="fadeInUp" data-delay=".1">SUPPORT</h6>
								<div class="wgs-body">
									<ul class="wgs-links wgs-links-uline wgs-links-s2 animated" data-animate="fadeInUp" data-delay=".2">
										<li><a href="intake.php">Get Help</a></li>
										<li><a href="emergency.php">Emergency Support</a></li>
										<li><a href="resources.php">Resources</a></li>
										<li><a href="safeguarding.php">Safeguarding</a></li>
										<li><a href="privacy.php">Privacy Policy</a></li>
									</ul>
								</div>
							</div>
						</div>

						<div class="col-lg-3 col-sm-4">
							<div class="wgs wgs-menu">
								<h6 class="wgs-title wgs-title-s2 text-white animated" data-animate="fadeInUp" data-delay=".3">ORGANISATION</h6>
								<div class="wgs-body">
									<ul class="wgs-links wgs-links-uline wgs-links-s2 animated" data-animate="fadeInUp" data-delay=".4">
										<li><a href="#about">About Us</a></li>
										<li><a href="#services">Our Services</a></li>
										<li><a href="#donate">Donate</a></li>
										<li><a href="volunteer.php">Volunteer</a></li>
										<li><a href="contact.php">Contact Us</a></li>
									</ul>
								</div>
							</div>
						</div>

						<div class="col-lg-3 col-sm-4">
							<div class="wgs wgs-menu">
								<h6 class="wgs-title wgs-title-s2 text-white animated" data-animate="fadeInUp" data-delay=".5">LEGAL</h6>
								<div class="wgs-body">
									<ul class="wgs-links wgs-links-uline wgs-links-s2 animated" data-animate="fadeInUp" data-delay=".6">
										<li><a href="privacy.php">Privacy Policy</a></li>
										<li><a href="terms.php">Terms & Conditions</a></li>
										<li><a href="safeguarding.php">Safeguarding Policy</a></li>
										<li><a href="accessibility.php">Accessibility</a></li>
									</ul>
								</div>
							</div>
						</div>

						<div class="col-lg-3 col-md">
							<div class="wgs wgs-subscribe-form">
								<h6 class="wgs-title wgs-title-s2 text-white animated" data-animate="fadeInUp" data-delay=".7">STAY CONNECTED</h6>
								<div class="wgs-body">
									<div class="wgs-subscribe">
										<p>Subscribe to receive updates and community news.</p>
										<form action="form/subscribe.php" class="nk-form-submit" method="post">
											<div class="field-inline field-inline-s3 field-split animated" data-animate="fadeInUp" data-delay=".8">
												<div class="field-wrap">
													<input class="input-bordered required" type="email" name="email" placeholder="Enter your email">
													<input type="text" class="d-none" name="form-anti-honeypot" value="">
												</div>
												<div class="submit-wrap">
													<button class="btn btn-icon btn-light btn-auto"><i class="fas fa-paper-plane"></i></button>
												</div>
											</div>
											<div class="form-results"></div>
										</form>
									</div>
								</div>
							</div>
						</div>

					</div>

					<div class="footer-bottom section-sm">
						<div class="row justify-content-between align-items-center">
							<div class="col-6">
								<a href="./" class="wgs-logo-s2">
									<img src="images/logo1-full-white.png" alt="Rahfav Foundation">
								</a>
							</div>
							<div class="col-6 text-right">
								<div class="copyright-text">
									<p>Copyright <?php echo $curryr ?> &copy; <?php echo $iname ?>. All Rights Reserved.</p>
								</div>
							</div>
						</div>
					</div>

				</div>
			</div>
		</section>
	</footer>

</div>

<div class="preloader"><span class="spinner spinner-round"></span></div>

<script src="assets/js/jquery.bundle.js?ver=192"></script>
<script src="assets/js/scripts.js?ver=192"></script>
<script src="assets/js/charts.js?ver=192"></script>

</body>
</html>