<?php
// app/timezone-fix.php

// Set default timezone for Nigeria
date_default_timezone_set('Africa/Lagos');

// Fix common PHP warnings
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Initialize common session variables to avoid notices
function initSessionVars() {
    $default_vars = array(
        'instcode', 'logid', 'pgid', 'stask', 'tstask', 'ttask',
        'text', 'invno', 'qearn', 'tuid', 'notee', 'uid', 'xsess',
        'verid', 'msg', 'alertid', 'tbal', 'logid', 'task', 'sdate',
        'edate', 'coupon', 'ufburl', 'utwurl', 'ulnurl', 'uggurl',
        'packid', 'email', 'fullname', 'uidno', 'ppass', 'pass',
        'status', 'location', 'phone', 'sid', 'slevel', 'street',
        'city', 'state', 'nation', 'currdate', 'styp', 'ktyp',
        'uwaddr', 'vntolbal', 'ritem', 'tokentran', 'withtran'
    );
    
    foreach ($default_vars as $var) {
        if (!isset($_SESSION[$var])) {
            $_SESSION[$var] = '';
        }
        if (!isset($GLOBALS[$var])) {
            $GLOBALS[$var] = '';
        }
    }
}

// Call this function early
initSessionVars();